%%%% DRCFitting

clear all; close all; clc;
addpath('./Functions/'); addpath('./Excel_Input/')

%define global parameters for the other scripts
global SAR_model SAR_MODEL nSAR

%%% List of file names %%%
filenamevec={['AMiage02A-IR50-NoHighD']};
 
%%% Number of measurements %%%
nSAR = [4];      %number of aliquots measured for SAR

%%%Select models%%%
SAR_model=[1]; %1 = SSE; %2 = DSE;

if SAR_model==1; SAR_MODEL='SSE'; elseif SAR_model==2; SAR_MODEL='DSE'; end;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% RUNNING THE MODEL %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

for j=1:size(filenamevec,1); %%% Loops through the different filenames %%

    filename=cell2mat(filenamevec(j,:));
    
    %%% Convert the excel file to a .mat format %%
      run Stage1_ExcelToStruct 

    %%% Fit the data using the selected model %%%
      run Stage2a_Fitparameters   
    
end
